--------------------------------------------------------------------------------------------
-- Add a changes layer with changes over one generation

local g = golly()
local gp = require "gplus"

local cellSet = 1
local cellNotSet = 0
local wd = g.getwidth()
local ht = g.getheight()
local yMax = (ht-1)//2
local yMin = yMax-ht+1
local xMax = (wd-1)//2
local xMin = xMax-wd+1

local currindex = g.getlayer()
local changeLayName = "ChangeLay"
local changeLay
local oldLayName = "OldLay"
local oldLay
local gen = g.getgen()

local oldpatt = g.getcells(g.getrect())
local numLays = g.numlayers()
if ( (numLays > 2) and (g.getname(numLays - 2) == changeLayName) and (g.getname(numLays - 1) == oldLayName)) then
   g.setlayer(numLays-1)
   g.dellayer()
   g.dellayer()
end
g.setlayer(g.numlayers()-1)
changeLay = g.addlayer()
g.setname(changeLayName)
g.setgen(gen)
g.setcolor("border", 196, 196, 196)
oldLay = g.addlayer()
g.setname(oldLayName)
g.setgen(gen)
--g.setcolor("border", 127, 127, 127)
g.putcells(oldpatt)

if (g.numstates() > 2) then
   cellNotSet = 2
   g.setlayer(changeLay)
   g.setcolors({2,255,255,255, 1,255,0,0})  --2 white, 1-red
   g.setlayer(oldLay)	
   g.setcolors({2,255,255,255, 1,0,0,0})  -- 2 white, 1-black
else
   g.setlayer(changeLay)
   g.setcolors({1,255,0,0})
   g.setlayer(oldLay)	
   g.setcolors({1,0,0,0})
end

g.setlayer(currindex)
g.run(1)
for i = xMin, xMax do
   for j = yMin, yMax do
      local v = g.getcell(i,j)
      g.setlayer(oldLay)
      if (g.getcell(i,j) ~= v) then
         g.setcell(i,j,cellNotSet)
         g.setlayer(changeLay)
         g.setcell(i,j,cellSet)
      else
         g.setlayer(changeLay)
         g.setcell(i,j,cellNotSet)
      end
      g.setlayer(currindex)
   end
end
g.setlayer(changeLay)
--g.setlayer(oldLay)
--g.dellayer() 
--g.setoption("stacklayers", 1)
g.setlayer(currindex)

------------------------------------------ eof -----------------------------------------